import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Layout, Range, RangeProps, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormRangePage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form Range Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requiredProps: RangeProps = {
      max: 100,
      min: 0,
      step: 1,
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'error',
            propValues: [false, true],
          },
        ]}
      >
        <Range {...requiredProps} />
        <Range {...requiredProps} disabled />
      </CombinationGenerator>
    );
  }
}
