import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, InputSize, Layout, SearchInput, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormSearchInputPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form SearchInput Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'error',
            propValues: [false, true],
          },
          {
            propKey: 'size',
            propValues: [undefined, InputSize.Large],
          },
        ]}
      >
        <SearchInput placeholder="Search" />
        <SearchInput placeholder="Search" disabled />
      </CombinationGenerator>
    );
  }
}
