import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, InputSize, Layout, Select, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormSelectPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form Select Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'size',
            propValues: [undefined, InputSize.Large],
          },
          {
            propKey: 'error',
            propValues: [false, true],
          },
        ]}
      >
        <Select>
          <option value="en">English</option>
          <option value="da">Dansk</option>
          <option value="de">Deutsch</option>
          <option value="en-gb">English - UK</option>
          <option value="es">Español - España</option>
          <option value="es-mx">Español - Latinoamérica</option>
          <option value="fr">Français</option>
          <option value="zh-cn">中文 简体</option>
          <option value="ja">日本語</option>
          <option value="ko">한국어</option>
        </Select>
        <Select disabled>
          <option value="en">English</option>
          <option value="da">Dansk</option>
          <option value="de">Deutsch</option>
          <option value="en-gb">English - UK</option>
          <option value="es">Español - España</option>
          <option value="es-mx">Español - Latinoamérica</option>
          <option value="fr">Français</option>
          <option value="zh-cn">中文 简体</option>
          <option value="ja">日本語</option>
          <option value="ko">한국어</option>
        </Select>
      </CombinationGenerator>
    );
  }
}
