import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, InputSize, Layout, TextArea, TextType } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormTextareaPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form TextArea Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'cols',
            propValues: [undefined, 10, 20],
          },
          {
            propKey: 'rows',
            propValues: [undefined, 10, 20],
          },
          {
            propKey: 'size',
            propValues: [undefined, InputSize.Large],
          },
          {
            propKey: 'noResize',
            propValues: [false, true],
          },
          {
            propKey: 'error',
            propValues: [false, true],
          },
        ]}
      >
        <TextArea />
        <TextArea disabled />
      </CombinationGenerator>
    );
  }
}
