import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Layout, TextType, Toggle } from '../../../../index';
import { CombinationGenerator } from '../../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class FormTogglePage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Form Toggle Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'error',
            propValues: [false, true],
          },
        ]}
      >
        <Toggle />
        <Toggle checked />
        <Toggle disabled />
      </CombinationGenerator>
    );
  }
}
