import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Background, CoreText, InFeatureNotification, InFeatureNotificationProps, InFeatureNotificationType, Layout, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class InFeatureNotificationPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>InFeatureNotification Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requireProps: InFeatureNotificationProps = {
      closeButtonAriaLabel: 'Close',
      description: 'Words',
      title: 'Title',
      type: InFeatureNotificationType.Neutral,
    };
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'title',
            propValues: ['A short title', 'A long title used to demonstrate how longer titles are used in context with the in feature notification component.'],
          },
          {
            propKey: 'description',
            propValues: ['Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer consectetur mi ac cursus pellentesque.', 'Donec aliquam et orci nec imperdiet. Integer iaculis dapibus suscipit. Phasellus vulputate sit amet dolor sit amet ultricies. Cras pulvinar eleifend ante, eu sagittis elit finibus ac. Ut rutrum id augue eu gravida. Phasellus sed lectus dolor. Fusce sit amet nunc fermentum, sollicitudin velit vel, laoreet lectus. Sed tempus erat ante, quis pretium justo mollis et.'],
          },
          {
            propKey: 'type',
            propValues: [InFeatureNotificationType.Error, InFeatureNotificationType.Info, InFeatureNotificationType.Neutral, InFeatureNotificationType.Success, InFeatureNotificationType.Warning],
          },
          {
            propKey: 'avatar',
            propValues: [undefined, { alt: 'Avatar' }],
          },
          {
            propKey: 'link',
            propValues: [undefined, { to: '/', children: 'Link to more information' }],
          },
          {
            propKey: 'actions',
            propValues: [undefined, [{ children: 'Action Item' }], [{ children: 'Action Item 1' }, { children: 'Action Item 2' }], [{ children: 'Action Item' }]],
          },
          {
            propKey: 'background',
            propValues: [Background.Base, Background.Alt, Background.Alt2],
          },
        ]}
      >
        <InFeatureNotification {...requireProps} />
        <InFeatureNotification {...requireProps} narrow />
      </CombinationGenerator>
    );
  }
}
