import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Color, CoreText, Layout, LoadingSpinner, LoadingSpinnerProps, SpinnerSize, StyledLayout, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class LoadingSpinnerPage extends React.Component<Props, {}> {
  public render() {
    return (
      <div>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H2}>LoadingSpinner Examples</CoreText>
          {this.renderExamples()}
        </Layout>
        <StyledLayout margin={{ bottom: 2 }} color={Color.Link}>
          <CoreText type={TextType.H2}>LoadingSpinner Inherit Color Examples</CoreText>
          {this.renderExamples({ inheritColor: true })}
        </StyledLayout>
        <StyledLayout margin={{ bottom: 2 }} color={Color.Error}>
          <CoreText type={TextType.H2}>LoadingSpinner Inherit Color Examples</CoreText>
          {this.renderExamples({ inheritColor: true })}
        </StyledLayout>
      </div>
    );
  }

  private renderExamples = (additionalProps: LoadingSpinnerProps = {}) => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'size',
            propValues: [SpinnerSize.Default, SpinnerSize.Small, SpinnerSize.Large],
          },
        ]}
      >
        <LoadingSpinner delay={0} {...additionalProps}/>
        <LoadingSpinner delay={2000} {...additionalProps}/>
      </CombinationGenerator>
    );
  }
}
