import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Layout, Pill, PillType, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class PillPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Pill Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'type',
            propValues: [PillType.Alert, PillType.Brand, PillType.Live, PillType.Notification, PillType.Overlay, PillType.Prime, PillType.Success, PillType.Warn],
          },
        ]}
      >
        <Pill label="1" />
        <Pill label="6942" />
        <Pill label="Pill label" />
      </CombinationGenerator>
    );
  }
}
