import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Layout, Presence, PresenceStatus, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class PresencePage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Presence Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'status',
            propValues: [PresenceStatus.Away, PresenceStatus.Busy, PresenceStatus.Invisible, PresenceStatus.Offline, PresenceStatus.Online],
          },
        ]}
      >
        <Presence />
      </CombinationGenerator>
    );
  }
}
