import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Layout, ProgressBar, ProgressBarSize, ProgressBarStatus, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class ProgressBarPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>ProgressBar Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'value',
            propValues: [0, 25, 50, 75, 100],
          },
          {
            propKey: 'mask',
            propValues: [false, true],
          },
          {
            propKey: 'size',
            propValues: [ProgressBarSize.Default, ProgressBarSize.Small, ProgressBarSize.ExtraSmall],
          },
        ]}
      >
        <ProgressBar status={ProgressBarStatus.Default} />
        <ProgressBar status={ProgressBarStatus.Caution} />
        <ProgressBar status={ProgressBarStatus.Error} />
        <ProgressBar status={ProgressBarStatus.Success} />
      </CombinationGenerator>
    );
  }
}
