import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Layout, Stat, StatProps, SVGAsset, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class StatPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Stat Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requireProps: StatProps = {
      icon: SVGAsset.Heart,
      label: 'Followers',
      value: '3,245',
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'label',
            propValues: ['Views', 'The best stat label ever'],
          },
          {
            propKey: 'icon',
            propValues: [SVGAsset.Heart, SVGAsset.GlyphLive, SVGAsset.GlyphViews],
          },
        ]}
      >
        <Stat {...requireProps} value="0" />
        <Stat {...requireProps} value="234" />
        <Stat {...requireProps} value="8,534,346" />
      </CombinationGenerator>
    );
  }
}
