import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { AlignItems, Background, Color, CoreText, JustifyContent, Layout, StyledLayout, StyledLayoutProps, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class StyledLayoutPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>StyledLayout Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const commonProps: StyledLayoutProps = {
      padding: 5,
      border: true,
      justifyContent: JustifyContent.Center,
      alignItems: AlignItems.Center,
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'color',
            propValues: [Color.Base, Color.Alt, Color.Alt2, Color.Error, Color.Inherit, Color.Link, Color.Live, Color.Overlay, Color.OverlayAlt],
          },
          {
            propKey: 'background',
            propValues: [Background.Accent, Background.AccentAlt, Background.AccentAlt2, Background.Alt, Background.Alt2, Background.Base, Background.Overlay],
          },
        ]}
      >
        <StyledLayout {...commonProps} elevation={0}>Text</StyledLayout>
        <StyledLayout {...commonProps} elevation={1}>Text</StyledLayout>
        <StyledLayout {...commonProps} elevation={2}>Text</StyledLayout>
        <StyledLayout {...commonProps} elevation={3}>Text</StyledLayout>
        <StyledLayout {...commonProps} elevation={4}>Text</StyledLayout>
        <StyledLayout {...commonProps} elevation={5}>Text</StyledLayout>
      </CombinationGenerator>
    );
  }
}
