import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { Color, CoreText, Layout, StyledLayout, SVG, SVGAsset, SVGProps, SVGType, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class SVGPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>SVG Examples</CoreText>
        <StyledLayout color={Color.Link}>
          {this.renderExamples()}
        </StyledLayout>
      </Layout>
    );
  }

  private renderExamples = () => {
    const requireProps: SVGProps = {
      asset: SVGAsset.LogoGlitch,
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'asset',
            propValues: [SVGAsset.LogoGlitch, SVGAsset.LogoTwitchPrime, SVGAsset.Heart],
          },
          {
            propKey: 'type',
            propValues: [SVGType.Alert, SVGType.Alt, SVGType.Alt2, SVGType.Brand, SVGType.Inherit, SVGType.Live, SVGType.OverlayPlaceholder, SVGType.Placeholder, SVGType.Prime, SVGType.Success, SVGType.Warn],
          },
        ]}
      >
        <SVG {...requireProps} />
        <SVG {...requireProps} width={40} height={40} />
        <SVG {...requireProps} width={60} height={60} />
        <SVG {...requireProps} width={160} height={160} />
      </CombinationGenerator>
    );
  }
}
