import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, JustifyContent, Layout, StyledLayout, TabSize, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';
import { TabsParentExample } from './components/tabs-parent-example';
import { TabsParentWithResizeLogicExample } from './components/tabs-parent-with-resize-logic-example';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class TabsPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout fullWidth>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H2}>Controlled Resize Logic Example</CoreText>
          <StyledLayout>
            <TabsParentWithResizeLogicExample
              activeTabIndex={0}
              tabs={[
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Lorem' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Ipsum' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Kappa' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'perspiciatis' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'omnis' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'voluptatem' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'accusantium' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'doloremque' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Lorem' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Ipsum' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Kappa' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'perspiciatis' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'omnis' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'voluptatem' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'accusantium' },
                { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'doloremque' },
              ]}
            />
          </StyledLayout>
        </Layout>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H2}>Tabs example with few items</CoreText>
          <StyledLayout>
            {this.renderNormalExamples()}
          </StyledLayout>
        </Layout>
        <Layout margin={{ bottom: 2 }}>
          <CoreText type={TextType.H2}>Tabs example with many items</CoreText>
          <StyledLayout>
            {this.renderLongTextExamples()}
          </StyledLayout>
        </Layout>
      </Layout>
    );
  }

  private renderNormalExamples() {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'size',
            propValues: [TabSize.Default, TabSize.Large],
          },
          {
            propKey: 'justifyContent',
            propValues: [undefined, JustifyContent.Start, JustifyContent.Center, JustifyContent.End],
          },
          {
            propKey: 'borderBottom',
            propValues: [false, true],
          },
        ]}
      >
        <TabsParentExample
          activeTabIndex={0}
          tabs={[
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Live Channels' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Videos' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Clips' },
          ]}
        />
      </CombinationGenerator>
    );
  }

  private renderLongTextExamples() {
    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'size',
            propValues: [TabSize.Default, TabSize.Large],
          },
          {
            propKey: 'justifyContent',
            propValues: [undefined, JustifyContent.Start, JustifyContent.Center, JustifyContent.End],
          },
        ]}
      >
        <TabsParentExample
          activeTabIndex={0}
          tabs={[
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'About' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Videos' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Events' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Super Really Long Word' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Following' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Foobar' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Lorem' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Ipsum' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'Kappa' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'perspiciatis' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'omnis' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'voluptatem' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'accusantium' },
            { linkTo: 'https://www.twitch.tv', onClick: this.preventClick, label: 'doloremque' },
          ]}
        />
      </CombinationGenerator>
    );
  }

  /**
   * Allows us to render a Core Link with an 'href' prop, but don't actually do anything when clicked.
   */
  private preventClick(e: React.FormEvent<HTMLElement>) {
    e.preventDefault();
  }
}
