import * as React from 'react';
import { TabsResizeHandler } from '../../../../../components/tabs/tabs';
import { Button, CoreText, Display, Layout, Tabs, TabsProps } from '../../../../../index';

interface State {
  activeIndex: number;
}

export class TabsParentWithResizeLogicExample extends React.Component<TabsProps, State> {
  public state = {
    activeIndex: 0,
  };

  private doResize: TabsResizeHandler;

  public render() {
    const props = {
      ...this.props,
      tabs: this.props.tabs.map((tab) => ({ ...tab, onClick: this.onClick })),
    };
    return (
      <Layout padding={3}>
        <CoreText>The example below shows a custom implementation which will only re-measure when you click these buttons.</CoreText>
        <Layout padding={{ y: 2 }}>
          <Tabs
            {...props}
            activeTabIndex={this.state.activeIndex}
            setupResizeHandler={this.setupResizeHandler}
          />
        </Layout>
        <Layout margin={1} display={Display.InlineBlock}><Button onClick={this.doQuickResize}>Do quick resize</Button></Layout>
        <Layout margin={1} display={Display.InlineBlock}><Button onClick={this.doFullResize}>Do expensive resize with measurements</Button></Layout>
      </Layout>
    );
  }

  private setupResizeHandler = (callback: TabsResizeHandler) => {
    this.doResize = callback;
  }

  private doQuickResize = () => {
    this.doResize();
  }

  private doFullResize = () => {
    this.doResize(true);
  }

  private onClick = (e: React.MouseEvent<HTMLElement>, index: number) => {
    e.preventDefault();
    this.setState({
      activeIndex: index,
    });
  }
}
