import * as React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { CoreText, Layout, SVGAsset, Tag, TagAction, TagProps, TagType, TextType } from '../../../index';
import { CombinationGenerator } from '../../components/combination-generator';

type RouteProps = RouteComponentProps<{}>;
type Props = RouteProps;

export class TagPage extends React.Component<Props, {}> {
  public render() {
    return (
      <Layout margin={{ bottom: 2 }}>
        <CoreText type={TextType.H2}>Tag Examples</CoreText>
        {this.renderExamples()}
      </Layout>
    );
  }

  private renderExamples = () => {
    const requireProps: TagProps = {
      label: 'Tag label',
    };

    return (
      <CombinationGenerator
        fields={[
          {
            propKey: 'action',
            propValues: [TagAction.Add, TagAction.Remove],
          },
          {
            propKey: 'icon',
            propValues: [undefined, SVGAsset.Team, SVGAsset.Trophy],
          },
          {
            propKey: 'disabled',
            propValues: [false, true],
          },
        ]}
      >
        <Tag {...requireProps} />
        <Tag {...requireProps} type={TagType.Accent} />
      </CombinationGenerator>
    );
  }
}
