# Functional Classes

## Modules

1. [Border](/src/sass/functional/border)
1. [Color](/src/sass/functional/color)
1. [Display](/src/sass/functional/display)
1. [Flex](/src/sass/functional/flex)
1. [Position](/src/sass/functional/position)
1. [Spacing](/src/sass/functional/spacing)
1. [Typography](/src/sass/functional/typography)

## Responsive Prefixing

Some functional classes support responsive breakpoints via prefixing. e.g.

`<div class="tw-xs-mg-1 tw-md-mg-2 tw-xl-mg-4">`

All prefixes, `xs`, `sm`, `md`, `lg`, `xl`, and `xxl` are supported. Classes that support responsive prefixes currently include:
```
  .tw-inline
  .tw-inline-block
  .tw-block
  .tw-hide
  .tw-overflow-
  .tw-float-
  .tw-relative
  .tw-absolute
  .tw-fixed
  .tw-pd-
  .tw-mg-
  .tw-font-size-
  .tw-align-center
  .tw-align-left
  .tw-align-right
  .tw-inline-flex
  .tw-flex-column
  .tw-flex-row
  .tw-flex-column-reverse
  .tw-flex-row-reverse
  .tw-item-order-0
  .tw-item-order-1
  .tw-item-order-2
  .tw-item-order-3
  .tw-item-order-4
```

## The Mixin

### Single Property
To build a class with a single property, provide the classname along with a map containing desired property and value. Such as:
```
@include build-classes((
  'underline': ('text-decoration', underline),
));
```

which outputs:
```
.tw-underline {
  text-decoration:
}
```

### Multiple Properties

### Multiple Properties, Same Value

You can specify multiple properties to have the same value:
```
'tw-mg-x': (
  (
    'margin-left',
    'margin-right'
  ), (
    'auto': auto,
    '1': 1rem
  )
)
```

which outputs:
```
.tw-mg-x-auto {
  margin-left: auto;
  margin-right: auto;
}

.tw-mg-x-1 {
  margin-left: 1rem;
  margin-right: 1rem;
}
```

### Multiple Properties, Multiple Values

You can supply a map of values that map to the declarations defined:

```
'font-size': (
  (
    'font-size',
    'line-height'
  ),
  (
    '1': (
      2.8rem,
      3rem
    )
  )
)
```

which outputs:
```
.tw-font-size-1 {
  font-size: 2.8rem;
  line-height: 3rem;
}
```
