// tslint:disable-next-line:no-any
export function getAriaProps(props: any) {
  let ariaProps: Record<string, {}> = {};

  for (let key of Object.keys(props).filter((k) => (k.startsWith('aria') && k.charAt(4) !== '-') || k === 'role')) {

    let aria: string;

    if (key !== 'role') {
      aria = 'aria-' + key.split('aria')[1].toLowerCase();
    } else {
      aria = key;
    }

    ariaProps[aria] = props[key];
  }
  return ariaProps;
}
