import { CoreImageProps } from '../components/core-image';

const PROP_KEYS = new Set(['alt', 'src', 'srcSet', 'sizes', 'onError', 'onLoad', 'refHandler']);

// tslint:disable-next-line:no-any
export function getImageProps(props: any): CoreImageProps {
  let dataProps: { [key: string]: {} } = {};
  for (let key of Object.keys(props)) {
    if (PROP_KEYS.has(key)) {
      dataProps[key] = props[key];
    }
  }

  return (dataProps as {}) as CoreImageProps;
}
