import * as history from 'history';
export function isExternalURL(to: string | history.LocationDescriptor) {
  let url: string | undefined;
  if (typeof to === 'string') {
    url = to;
  } else if (to.pathname) {
    url = to.pathname;
  }
  if (url && (/^\w+:\/\//.test(url) || url.startsWith('//'))) {
    return true;
  }
  return false;
}
