/**
 * This config file may be used by consumers of this packages
 */
module.exports = {
  "extends": "stylelint-config-standard",
  "plugins": [
    "stylelint-scss",
  ],
  "rules": {
    "at-rule-no-unknown": null,
    "block-no-empty": true,
    "color-hex-case": "lower",
    "color-no-invalid-hex": true,
    "declaration-bang-space-after": "never",
    "declaration-bang-space-before": "always",
    "declaration-block-no-duplicate-properties": true,
    "declaration-colon-space-after": "always-single-line",
    "declaration-colon-space-before": "never",
    "declaration-empty-line-before": null,
    "declaration-no-important": true,
    "indentation": 2,
    "max-empty-lines": 2,
    "no-descending-specificity": null,
    "no-duplicate-selectors": null,
    "no-empty-source": null,
    "no-missing-end-of-source-newline": true,
    "number-leading-zero": "always",
    "property-no-vendor-prefix": true,
    "rule-empty-line-before": null,
    "scss/at-function-pattern": "^[a-z-]+$",
    "scss/at-import-no-partial-leading-underscore": true,
    "scss/at-rule-no-unknown": true,
    "scss/dollar-variable-colon-space-after": "always-single-line",
    "scss/dollar-variable-colon-space-before": "never",
    "scss/dollar-variable-pattern": "^[0-9a-z-]+$",
    "selector-attribute-quotes": "always",
    /**
     * Classnames must not begin with 'tw-' as this prefix indicates a
     * private Core UI class name which should not be overwritten.
     */
    "selector-class-pattern": ["^(?!tw-).+[a-z-_]+$", {
      "resolveNestedSelectors": true,
      "message": "Class names may contain lowercase letters, hyphens, or underscores and must not start with 'tw-'.",
    }],
    "selector-max-id": 0,
    "selector-max-type": 0,
    /**
     * Combinators are forbidden to help enforce code maintainability;
     * each stylesheet file should only apply properties to elements which it can
     * directly add a unique classname to.
     *
     * Examples: https://stylelint.io/user-guide/rules/selector-max-combinators/
     */
    "selector-max-combinators": [0, {
      "message": "Combinators are not allowed; please target each DOM node with a unique class name using the BEM naming convention."
    }],
    "selector-max-universal": 0,
    "selector-no-vendor-prefix": true,
    "selector-pseudo-class-no-unknown": true,
    "selector-pseudo-element-colon-notation": "double",
    "selector-pseudo-element-no-unknown": true,
    "selector-type-no-unknown": true,
    "shorthand-property-no-redundant-values": true,
    "string-quotes": "single",
    "unit-whitelist": [['rem', 's'], {
      "ignoreProperties": {
        "px": ["/^border/", "box-shadow"],
        "%": ["top", "right", "bottom", "left"],
        "vw": ["width", "min-width", "max-width"],
        "vh": ["height", "min-height", "max-height"],
        "em": ["letter-spacing"],
      },
    }],
    "value-list-comma-space-after": "always-single-line",
    "value-list-comma-space-before": "never-single-line",
  }
}
