module.exports = {
  transform: {
    '^.+\\.tsx?$': 'ts-jest'
  },
  testRegex: '(<rootDir>/.*|(\\.|/)(test|spec))\\.(tsx?)$',
  testURL: 'https://localhost/',
  moduleFileExtensions: [
    'ts',
    'tsx',
    'js',
    'jsx',
    'json',
    'node'
  ],
  moduleDirectories: [
    '<rootDir>/src',
    'node_modules'
  ],
  moduleNameMapper: {
    '\\.(jpg|jpeg|png|gif|eot|otf|webp|svg|ttf|woff|woff2|mp4|webm|wav|mp3|m4a|aac|oga)$': '<rootDir>/src/core/mocks/fileMock.ts',
    '\\.(css|scss|sass)$': '<rootDir>/src/core/mocks/styleMock.ts'
  },
  setupTestFrameworkScriptFile: '<rootDir>/setupTest.ts',
  "transformIgnorePatterns": [
    "node_modules/(?!(carbon-components-prototype))"
  ]
}
