import { Background, Column, CoreImage, EditorialDetail, Grid, GridGutterSize, Layout } from 'carbon-components-prototype';
import { withGraphQL } from 'core/utils/with-graphql';
import * as React from 'react';
import { GraphqlQueryControls } from 'react-apollo';
import { compose } from 'redux';
import * as userQuery from './user.gql';

interface Data {
    tuid: string;
    ecid: string;
}

interface GraphQLProps {
    data: Data & GraphqlQueryControls;
}

type Props = GraphQLProps;

export class UserInfoView extends React.Component<Props, {}> {
    public render() {
        if (!this.props.data) {
            return (
                <div>THIS IS AN ERROR</div>
            );
        }

        if (this.props.data && this.props.data.loading) {
            return (
                <div>THIS IS LOADING</div>
            );
        }

        return (
            <Layout
                className="sm-offer-editorial"
                fullHeight={true}
            >
                {JSON.stringify(this.props.data)}
            </Layout>
        );
    }
}

export const UserInfo: React.ComponentClass = compose(
    withGraphQL(userQuery),
)(UserInfoView);
