import { applyMiddleware, compose, createStore } from 'redux';
import { configureMiddleware } from './middleware';

// tslint:disable-next-line:no-string-literal
const composeEnhancers = process.env.NODE_ENV !== 'production' && window['__REDUX_DEVTOOLS_EXTENSION_COMPOSE__'] || compose;
export async function configureStore(rootReducer) {
  const middleware = await configureMiddleware();
  return createStore(
    rootReducer,
    composeEnhancers(applyMiddleware(...middleware)),
  );
}
