function isResponse(val) {
  return val && typeof val.json === 'function';
}

export function fetchMiddleware({ dispatch }) {
  return (next) => (action) => {
    if (isResponse(action.payload)) {
      if (action.payload.ok) {
        dispatch({ ...action, payload: action.payload.json() });
      } else {
        action.payload.json().then((data) => {
          dispatch({ ...action, payload: new Error(data.errorCode || 'network error'), error: true });
        });
      }
    }
    return next(action);
  };
}
