function isPromise(val) {
  return val && typeof val.then === 'function';
}

export function promiseMiddleware({ dispatch }) {
  return (next) => (action) => {
    if (isPromise(action.payload)) {
      action.payload.then(
        (result) => dispatch({ ...action, payload: result })
      , (error) => dispatch({ ...action, payload: new Error(error), error: true }),
      );
    }

    return next(action);
  };
}
