import { IntrospectionFragmentMatcher } from 'apollo-cache-inmemory';

export const fragmentMatcher = new IntrospectionFragmentMatcher({
  introspectionQueryResultData: {
    __schema: {
      types: [
        {
          kind: 'UNION',
          name: 'BitsOffer',
          possibleTypes: [
            { name: 'BitsAdOffer' },
            { name: 'BitsBundleOffer' },
          ],
        },
        {
          kind: 'UNION',
          name: 'Activity',
          possibleTypes: [
            { name: 'PlayingActivity' },
            { name: 'StreamingActivity' },
            { name: 'WatchingActivity' },
          ],
        }, {
          kind: 'UNION',
          name: 'FeedItem',
          possibleTypes: [
            { name: 'Post' },
            { name: 'Video' },
            { name: 'Stream' },
            { name: 'Clip' },
          ],
        }, {
          kind: 'UNION',
          name: 'PostEmbed',
          possibleTypes: [
            { name: 'Video' },
            { name: 'Clip' },
            { name: 'Stream' },
            { name: 'PhotoOEmbed' },
            { name: 'VideoOEmbed' },
          ],
        }, {
          kind: 'INTERFACE',
          name: 'Panel',
          possibleTypes: [
            { name: 'DefaultPanel' },
            { name: 'ExtensionPanel' },
          ],
        }, {
          kind: 'INTERFACE',
          name: 'Directory',
          possibleTypes: [
            { name: 'Game' },
            { name: 'Community' },
          ],
        },
      ],
    },
  },
});
