import { getQueryParam } from 'core/utils/queryParam';

describe('Query Param Utils', () => {
    it('returns the date override when it exists as a query param', () => {
        const url = 'https://this.location.isawesome?dateOverride=';
        const dateOverrideValue = '2018-09-10T00:00:00Z';
        const dateOverride = getQueryParam(`${url}${dateOverrideValue}`, 'dateOverride');

        expect(dateOverride).toEqual(dateOverrideValue);
    });

    it('returns an empty when date override does not exist on the url', () => {
        const url = 'https://this.location.isawesome';
        const dateOverride = getQueryParam(`${url}`, 'dateOverride');

        expect(dateOverride).toEqual('');
    });
});
