
export const getQueryParam = (search: string, param: string) => {
    const name = param.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    const regex = new RegExp(/[\\?&]' + name + '=([^&#]*)'$/);
    const results = regex.exec(search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
};
