import { apolloClient } from 'core/store/clients';
import { configureStore } from 'core/store/configureStore';
import { Root } from 'pages/Root';
import * as React from 'react';
import { ApolloProvider } from 'react-apollo';
import { render } from 'react-dom';
import { Provider } from 'react-redux';
import { rootReducer } from 'rootReducer';
import 'whatwg-fetch';

async function start(): Promise<void> {
  const store = await configureStore(rootReducer);

  render(
    <ApolloProvider client={apolloClient}>
      <Provider store={store}>
        <Root />
      </Provider>
    </ApolloProvider>,
    document.getElementById('root'),
  );
}

start();
