import { Background, EditorialDetail, StyledLayout } from 'carbon-components-prototype';
import { OfferEditorial } from 'components/OfferEditorial';
import { UserInfo } from 'components/UserInfo';
import * as React from 'react';
import './styles.scss';

export interface PublicProps {
  theme: string;
}

type Props = PublicProps;
export class RootPresentation extends React.Component<Props> {
  public render() {
    this.setCurrentTheme(`tw-root--theme-${this.props.theme}`);
    return (
      <StyledLayout
        fullHeight={true}
      >
        <OfferEditorial />
        <UserInfo />
      </StyledLayout>
    );
  }

  private setCurrentTheme = (name: string) => {
    const wrapper = document.querySelector('html');

    if (wrapper) {
      wrapper.classList.remove('tw-root--theme-light');
      wrapper.classList.remove('tw-root--theme-dark');
      wrapper.classList.add(name);
    }
  }
}
