export const pause = () => {
  // When we've mocked `setTimeout()` using `jest.useFakeTimers()`, it won't
  // resolve until we call `jest.runOnlyPendingTimers()` (or another one of
  // the timer-running functions. Unfortunately, this makes the code
  // synchronous and doesn't actually provide the `pause()` behavior we
  // desire. For some reason, `setImmediate` seems to work as expected. I
  // don't really understand why it works, but here's a comment on GH
  // describing the same behavior:
  //
  // https://github.com/facebook/jest/issues/2157#issuecomment-279169745
  //
  const setTimeoutFn = jest.isMockFunction(setTimeout) ? setImmediate : setTimeout;
  return new Promise(setTimeoutFn);
};
