var { resolve } = require('path');
var webpack = require('webpack');
var HtmlPlugin = require('html-webpack-plugin');
var CopyAssetsPlugin = require('copy-webpack-plugin');
var LicenseWebpackPlugin = require('license-webpack-plugin').LicenseWebpackPlugin;

const isProduction = process.env.NODE_ENV === 'production';

module.exports = (app) => ({

  context: resolve('src'),

  entry: [
    'whatwg-fetch',
    'index.tsx'
  ],

  devServer: {
    historyApiFallback: !isProduction,
    disableHostCheck: !isProduction
  },

  devtool: !isProduction && 'source-map',

  output: {
    filename: 'js/[name].[chunkhash].js',
    path: resolve('dist'),
    pathinfo: !isProduction
  },

  module: {
    rules: [
      {
        test: /\.(graphql|gql)$/,
        exclude: /node_modules/,
        use: [
          {
            loader: 'graphql-tag/loader'
          },
        ]
    },
    {
      test: /\.(js|ts|tsx?)$/,
      loader: 'awesome-typescript-loader',
      include: [ resolve('node_modules/carbon-components-prototype'), resolve('src') ],
      exclude: [ resolve('node_modules/apollo-cache-inmemory') ]
    }, 
    {
      test: /\.(sass|scss)$/,
      loaders: [
        'style-loader',
        'css-loader',
        {
          loader: 'postcss-loader',
          options: {
            config: {
              path: './postcss.config.js'
            }
          }
        },
        {
          loader: 'sass-loader',
          options: {
            sourceMap: true,
            includePaths: [ resolve('node_modules', 'carbon-components-prototype', 'src', 'scss') ]
          }
        }
      ]
    },
    {
      test: /\.(gif|png|jpe?g)$/i,
      loader: 'file-loader',
      options: { name: 'images/[hash].[ext]' }
    }, 
    {
      test: /\.(ttf|otf|eot|woff2?)$/i,
      loader: 'file-loader',
      options: { name: 'fonts/[hash].[ext]' }
    }]
  },

  resolve: {
    extensions: [ '.ts', '.tsx', '.js', '.json' ],
    modules: [ 'src', 'node_modules' ]
  },

  plugins: [

    !isProduction && new webpack.NamedModulesPlugin(),
    !isProduction && new webpack.NoEmitOnErrorsPlugin(),

    isProduction && new webpack.HashedModuleIdsPlugin(),
    isProduction && new LicenseWebpackPlugin({
      pattern: /.*/,
      unacceptablePattern: /GPL/,
      abortOnUnacceptableLicense: true
    }),

    // Inject environment variables.
    new webpack.EnvironmentPlugin({
      NODE_ENV: null
    }),
  
     // Generate the HTML document.
     new HtmlPlugin({
      template: resolve('public', 'index.html'),
      filename: 'index.html',
      inject: !isProduction
    }),

    // Copy static assets to the output
    new CopyAssetsPlugin([{
      from: resolve('src', 'assets')
    }]),

    // Shim Promise
    new webpack.ProvidePlugin({
      Promise: 'promise-polyfill',
    }),

  ].filter(Boolean) // Remove the booleans that may be left in the array

})

