---
title: "Onboarding Guide"
page-category: "searchable"
description: "Our onboarding guide for setting up your environment, creating builds, using templates, and general Carbonite guidelines."
---
>**Pro tip:** Follow this page before you write any code in Carbonite!
{:.note}

**To get started with Carbonite**
1. Learn [about Carbonite](#about-carbonite).
1. Get [permissions](#permissions) and subsribe to our various [information channels](#information-channels) to make sure you can push code and you're notified when changes happen to Carbonite.
1. Set up your [dev environment](#setting-up-your-dev-environment).
1. Read about [developing in Carbonite](#developing-in-carbonite).
1. Get your hands dirty with some [tutorials](#tutorials).
1. Read about our [CR process process and release cycle](#getting-code-into-production).

## About Carbonite

Carbonite is the web client that powers twitch.amazon.com/tp, built with React, TypeScript, Redux, and GraphQL. Carbonite leverages [SamusCarbonComponents](https://code.amazon.com/packages/SamusCarbonComponents/trees/mainline){:target="_blank"} for many presentational components and styles and includes internationalization tooling and automation.

## Permissions

TO BE ADDED

## Information Channels

1. email-list: [samus-carbon-interest](https://email-list.corp.amazon.com/email-list/expand-list/samus-carbon-interest)
2. chime channel: 

### Setting up your dev environment

1. If you don't have an IDE installed yet, install your IDE of choice. Most Carbnoite contributors use VSCode. The Carbon team recommends using [VS Code](https://code.visualstudio.com/){:target="_blank"} with [these VS Code extensions](https://code.amazon.com/packages/CarboniteApp/blobs/roboCopLocalDevBranch/--/.vscode/extensions.json){:target="_blank"}. If not using VS Code, you should at least install the [Prettier extension for your editor](docs/basics/techstack.html#prettier).
1. Install NVM
    ```ts
    curl https://raw.githubusercontent.com/creationix/nvm/v0.33.11/install.sh -O
    chmod +x install.sh
    ./install.sh
    ```
1. Install Node 10, 8 (lts), 6
    ```ts
    nvm install --lts
    nvm install v6.14.4
    nvm install v8.12.0
    nvm install v10.12
    nvm use --lts
    ```
1. Setup node for brazil
    ```ts
    brazil setup --node
    Node 10.x path (i.e the path of node executable)
    [?]: /Users/{YOURUSER}/.nvm/versions/node/v10.12.0/bin/node
    Node 8.x path (i.e the path of node executable)
    [?]: /Users/{YOURUSER}/.nvm/versions/node/v8.12.0/bin/node
    Node 6.x path (i.e the path of node executable)
    [?]: /Users/{YOURUSER}/.nvm/versions/node/v6.14.4/bin/node
    Node other path (i.e the path of node executable)
    [?]: (just press enter)
    ```
1. Setup development workspace
    ```ts
    brazil ws create --root <whatever/path/you/want/CarboniteApp> --name CarboniteApp --versionset CarboniteWebsite/development
    cd <whatever/path/you/want/CarboniteApp>
    brazil ws use -p CarboniteApp
    ```
## Developing in Carbonite

TO BE ADDED

### Project organization

At the top level, components organized by type: 

* `src/common` - Common components used across features and pages. They are built as flexible modules that can be used in many contexts. A date-picker, a copy-button, and a latency-tracking component are all good examples of common components.
* `src/pages-container` - Layout wrappers for pages that provide base functionality such as top-nav, side-nav, or footer.
* `src/pages` - Components that have a routable URL and are typically composed of one or more helper components and features. Upsell Page, Prime Page, Country Page are all good examples of page components.
* `src/features` - Non-routable components that may appear on more that one page. Unlike common components, they are specific to product domains. Chat, search, and the video player are all features.

All component directories start with this basic structure:

```ts
src/features/foo/
  components/
    bar/
      component.tsx
      component.test.tsx
      index.ts
  index.ts
```
See [File Organization and Naming](docs/basics/coding-style.html) for more information.

### Code generators

TO BE ADDED

#### Component generator

TO BE ADDED

#### GraphQL interface generator

If you add a GraphQL query, mutation, or fragment, use the `brazil-build gql` command to generate an interface for it in `carbon/core/graphql/schema`. Learn more about [generating GraphQL interfaces](docs/guides/data-access.html#generating-graphql-interfaces).

### Debugging with VS Code

If you use VS Code as your development environment, you have the option of debugging a local instance of Carbonite right in the IDE. Microsoft has a [Debugger for Chrome](https://github.com/Microsoft/vscode-chrome-debug) extension that will handle starting up a new instance of Chrome that is attached to VS Code. To get started...

- In VS Code, download the extension by going to the Extensions sidebar and looking in the "Recommended" section
- Start Carbonte however you normally would (`brazil-build start`)
- In VS Code, open the debugging menu in the sidebar
- Choose the *Debug Chrome in VS with 'Debugger for Chrome' extension* profile in the dropdown at the top of the sidebar
- Press the "play" button to start a debugging session
- A new Chrome instance should open
- Set a breakpoint in VS Code by clicking in the line number gutter
- Interact with Carbonite to trigger that code path
- See the debugger stop execution in the Chrome instance and set focus on the breakpoint in VS Code

From there, you should be able to step through code and inspect values. Press the "Stop" button to end the debugging session.

### Accessing backend staging environments in development

### Adding a data layer

Use [GraphQL](docs/guides/data-access.html) to get data from the Carbonite backend. Carbonite uses [Apollo](docs/basics/techstack.html#apollo) to manage GraphQL data access cache GraphQL requests. 

When adding a GraphQL query to your component, [be careful to avoid adding a data waterfall](docs/guides/data-loading.html#data-waterfalls) (also known as an N+1 or ripple query).

### Weblabs

### Internationalization

Carbonite has formatting helpers to make it easy to ensure your strings, dates, and times are properly internationalized. Learn more about [formatting values for localization](docs/guides/internationalization.html).

Strings must be translated before they go into master. Follow [this process on your branch to submit strings for translation](docs/processes/localization-process.html#submitting-strings-for-translation). As part of the process, you can provide context to help translators properly translate your strings.

### Testing

Carbonite emphasizes unit tests for all components. To make testing as painless as possible, `shallow` test by default and only `mount` or `render` test if absolutely necessary. Read our guidance on [test coverage](docs/testing/testing.html#test-coverage) and then dive into [unit testing basics](docs/testing/unit-testing-basics.html) and look at common [unit testing patterns](docs/testing/unit-testing-patterns.html).

## Tutorials
Now that you've read about the basics of developing in Carbonite, it's time to put that knowledge to the test with some tutorials.
* New to React? Complete the [React intro tutorial](https://reactjs.org/tutorial/tutorial.html){:target="_blank"}.
* New to TypeScript? Check out the [TypeScript in 5 minutes tutorial](https://www.typescriptlang.org/docs/handbook/typescript-in-5-minutes.html){:target="_blank"} and then complete the [TypeScript React Starter](https://github.com/Microsoft/TypeScript-React-Starter#typescript-react-starter){:target="_blank"}.
* If you're already familiar with React and TypeScript, complete the [Carbonite tutorial](docs/tutorials/tutorial-channel-info-bar1.html).

#### Code reviews

If you're a code owner, you'll eventually have to review someone else's code. See [our guidance for code reviews](docs/releases/code-reviews.html).
