var { resolve } = require('path')
var webpack = require('webpack')
var HtmlPlugin = require('html-webpack-plugin')

module.exports = app => ({
  output: {
    filename: 'js/[name].[hash].js',
    pathinfo: true
  },
  devServer: {
    historyApiFallback: true,
    overlay: true,
    https: true,
    public: 'localhost:8080',
    disableHostCheck: true
  },
  devtool: 'source-map',
  plugins: [
    new webpack.NamedModulesPlugin(),
    new webpack.NoEmitOnErrorsPlugin(),
    new HtmlPlugin({
      template: resolve('src', 'templates', 'dev.html'),
      inject: false,
      app
    })
  ]
})
