import { GET_ACTIVE_BATTLE_URL, GET_BATTLE_STATUS_URL, START_BATTLE_URL } from "./constants";

 /**
  * Provides static utility methods for Twitch API calls.
  */
export default class DreadPiratesClient {
   /**
    * @return a Promise that resolves to a OverlayExtension object.
    */
   public static StartBattle({ channelID }) {
        const parameterizedURL = START_BATTLE_URL.replace("{user}", channelID);
        const headersInit = {
          "content-type": "text/plain",
        };
        const headers = new Headers(headersInit);

        const options: RequestInit = {
          headers,
          method: "POST",
          mode: "cors",
        };
        return fetch(parameterizedURL, options);
   }

   public static GetActiveBattle({ channelID }) {
        const parameterizedURL = GET_ACTIVE_BATTLE_URL.replace("{user}", channelID);
        const headersInit = {
            "content-type": "text/plain",
        };
        const headers = new Headers(headersInit);

        const options: RequestInit = {
            headers,
            method: "GET",
            mode: "cors",
        };
        return fetch(parameterizedURL, options);
   }

   public static GetBattleStatus({ channelID, matchID }) {
    let parameterizedURL = GET_BATTLE_STATUS_URL.replace("{user}", channelID);
    parameterizedURL = parameterizedURL.replace("{id}", matchID);
    const headersInit = {
        "content-type": "text/plain",
    };
    const headers = new Headers(headersInit);

    const options: RequestInit = {
        headers,
        method: "GET",
        mode: "cors",
    };
    return fetch(parameterizedURL, options);
}
 }
