declare var Twitch: any;

import { setErrorMessage } from "core/store/modules/ErrorMessage";
import { handleTwitchExtensionContext } from "core/store/modules/TwitchExtension";
import handleTwitchExtensionAuthorizedWorkflow from "core/store/workflows/handleTwitchExtensionAuthorizedWorkflow";

/**
 * @param store a redux store
 */
export default function connectTwitchExtension(store) {
  if (!Twitch) {
    store.dispatch(setErrorMessage("Twitch init failed."));
    return;
  }
  Twitch.ext.onAuthorized((auth) => store.dispatch(handleTwitchExtensionAuthorizedWorkflow(auth)));
  Twitch.ext.onContext((context) => store.dispatch(handleTwitchExtensionContext(context)));
}
