/**
 * ErrorMessageModule reducer.
 */

import { CLEAR_ERROR_MESSAGE, SET_ERROR_MESSAGE } from "./constants";

export function errorMessage(state: string = null, action): string {
  if (action.error) {
    return action.payload.message || action.payload;
  }
  switch (action.type) {
    case SET_ERROR_MESSAGE:
      return action.payload;
    case CLEAR_ERROR_MESSAGE:
      return null;
    default:
      return state;
  }
}
