import { name, authorization, context } from './constants'

export function selectTwitchExtension(state) {
  return state[name];
};

export function selectAuthorization(state) {
  return state[name][authorization];
};

export function selectUserId(state) {
  return state[name] && state[name][authorization] && state[name][authorization].userId || '';
}

export function selectChannelId(state) {
  return state[name] && state[name][authorization] && state[name][authorization].channelId || '';
}

export function selectToken(state) {
  return state[name] && state[name][authorization] && state[name][authorization].token || '';
}

export function selectContext(state) {
  return state[name][context];
};

export function selectIsLoggedIn(state) {
  return !!state[name] && !!state[name][authorization] && !!state[name][authorization].userId;
};
