import { getStreamerContext } from 'core/store/modules/Twitch';
import { handleTwitchExtensionAuthorized } from 'core/store/modules/TwitchExtension';
import { getActiveBattle } from 'core/store/modules/DreadPirates';

/**
 * Describe business workflow for handling the TwitchExtension Auth data.
 *
 * @return a redux thunk
 */
export default function handleTwitchExtensionAuthorizedWorkflow(auth) {
  return (dispatch, getState) => {

    // Handle auth data with TwitchExtensionModule
    dispatch(handleTwitchExtensionAuthorized(auth));

    // Get the streamer's name.
    dispatch(getStreamerContext({ channelID: auth.channelId }));
  };
}