import connectTwitchExtension from "core/connectTwitchExtension";
import configureStore from "core/store/configureStore";
import * as React from "react";
import { render } from "react-dom";
import { Provider } from "react-redux";
import { Root } from "viewer/Root";
import rootReducer from "viewer/rootReducer";

import "whatwg-fetch";

async function start(): Promise<void> {

  const store = await configureStore(rootReducer);
  
  connectTwitchExtension(store);

  render(
    <Provider store={ store }>
      <Root/>
    </Provider>,
    document.getElementById("root"),
  );
}

start();
