import * as React from "react";
import "./styles.scss";
import { StartBattleButton } from "viewer/components/StartBattleButton";
import { Battle } from "viewer/components/Battle";

const COLLAPSED_TIMEOUT = 1000; // One second.

// Props shape.
export interface Props {
  channelId: string,
  userId: string,
  matchID: string,
  getBattleStatus: () => {},
}

// React component.
export class RootComponent extends React.Component<Props> {

  // Render.
  public render() {
    return (
      <div className="dread-pirates">
        {(this.canStartBattle() && !this.props.matchID) &&
          <StartBattleButton />
        }
        {(this.props.matchID) &&
          <div>
            {this.props.getBattleStatus()}
            <Battle />
          </div>
        }
      </div>
    )
  }

  private canStartBattle() {
    if (this.props.userId.includes(this.props.channelId)) {
      return true;
    }
    return false;
  }
}
