import { connect } from "react-redux";
import { RootComponent } from "./component";
import { selectChannelId, selectUserId } from "core/store/modules/TwitchExtension";
import { getBattleStatus, selectMatchID, selectEventType } from "core/store/modules/DreadPirates";

const mapStateToProps = (state) => ({
  channelId: selectChannelId(state),
  userId: selectUserId(state),
  matchID: selectMatchID(state)
});

const mapDispatchToProps = (dispatch) => ({
  getBattleStatus: (channelId, matchID) => {
    let getActiveBattlePoller = setInterval(() => {
        dispatch(getBattleStatus({ channelID: channelId, matchID: matchID }))
    }, 5000);
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  getBattleStatus: () => dispatchProps.getBattleStatus(stateProps.channelId, stateProps.matchID),
});

export const RootContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(RootComponent);
