import * as React from "react";
import "./styles.scss";
import { Rock } from "viewer/components/Rock";

export interface Props {
    alive: boolean;
    opponent: boolean;
    boss: boolean;
    damage: number;
    throwingRock?: boolean;
}

export interface State {
    imageUrl: string;
    position: number;
    toggle: boolean;
}

const avatars = [
    "/gifs/flower_power.gif",
    "/gifs/ice_cream.gif",
    "/gifs/pineapple.gif",
    "/gifs/walking_angry.gif"
];

const bossAvatars = [
    "/gifs/GUNDAMBOSS.gif"
];

const deadViewer = "/gifs/Shiny_rip.gif";
const deadBoss = "/gifs/deadgif.gif";

export class AvatarComponent extends React.Component<Props, State> {
    constructor(props) {
        super(props);
        let avatarImage
        if (!props.boss) {
            const randomNumber = this.getRandomInt(0, avatars.length - 1);
            avatarImage = avatars[randomNumber];
        }
        else {
            const randomNumber = this.getRandomInt(0, bossAvatars.length - 1);
            avatarImage = bossAvatars[randomNumber];
        }

        const randomPosition = this.getRandomInt(0, 30);
        this.state = { imageUrl: avatarImage, position: randomPosition, toggle: true };
    }
    public componentWillReceiveProps(nextProps) {
        if (nextProps.damage !== 0) {
            this.setState({toggle : !this.state.toggle});
        }
    }

    public render() {
        let margin = this.props.opponent ? (100 - this.state.position - 12) + "%" : this.state.position + 12 + "%";
        margin = this.props.boss ? "auto" : margin;
        const randomNumber = (this.getRandomInt(25, 100)) / 100;
        const style = {
            marginLeft: margin,
            width: this.props.boss ? "12rem" : "3rem",
            transform: this.props.opponent ? "scaleX(-1)" : "none",
            left: this.props.boss && !this.props.opponent ? 0 : "inherit",
            right: this.props.boss && this.props.opponent ? 0 : "inherit",
            animationDuration: this.props.boss || !this.props.alive ? "0s" : randomNumber + "s",
            zIndex: this.props.alive ? 50 : 100
        }
        let imageUrl = this.state.imageUrl;
        if (!this.props.alive && this.props.boss) {
            imageUrl = deadBoss;
        }
        else if (!this.props.alive) {
            imageUrl = deadViewer;
        }
        let className = "avatar";
        className = this.props.boss ? className + " boss" : className + " viewer";
        className = this.props.boss && this.props.damage !== 0 ? className + " damaged" : className;
        const damageStyle = {
            left: this.props.boss && !this.props.opponent ? "6rem"  : "inherit",
            right: this.props.boss && this.props.opponent ? "6rem" : "inherit"
        }
        const damageClass = this.props.opponent ? "damaged-opponent" : "damaged-me";
        return (
            <div>
                {(this.props.damage !== 0  &&
                    <div>
                        <div className={this.state.toggle === true ? "damage-number" : null} style={damageStyle}>-{this.props.damage}</div>
                        <div className={this.state.toggle === false ? "damage-number" : null} style={damageStyle}>-{this.props.damage}</div>
                    </div>
                )}
                <div className={this.props.boss && this.props.damage !== 0 ? damageClass : ""}>
                    <img className={className} style={style} src={imageUrl} />
                </div>
                {this.props.throwingRock && this.props.alive &&
                    <Rock marginLeft={margin} flip={this.props.opponent} animationDelayMS={this.getRandomInt(1000, 2000)} />
                }
            </div>
        )
    }

    private getRandomInt(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
};