import * as React from "react";
import { Avatar } from "viewer/components/Avatar";
import "./styles.scss";

export interface Props {
    channelId: string,
    player1: {
        channelId: string,
        crowdSize: number,        
        currentHP: number;
        interaction: number;
        maxHP: number;
        previousHP: number;
        pogChamps: number;
    },
    player2: {
        channelId: string,
        crowdSize: number,
        currentHP: number;
        interaction: number;
        maxHP: number;
        previousHP: number;
        pogChamps: number;
    },
    eventType: string,
    startBattle: () => void
}

export class BattleComponent extends React.Component<Props> {
    public render() {
        if (this.props.player1) {
            const myStats = this.getMyStats();
            const opponentStats = this.getOpponentStats();
            let myDamage = 0;
            let opponentDamage = 0;
            let myNumberDead = 0;
            let opponentNumberDead = 0;
            if (this.props.player1.maxHP) {
                myDamage = myStats.currentHP === 0 ? 0 : this.getDamageDone(myStats.previousHP, myStats.currentHP);
                myNumberDead = myStats.crowdSize - Math.round(((myStats.currentHP/myStats.maxHP) * myStats.crowdSize));
                opponentDamage = opponentStats.currentHP === 0 ? 0 : this.getDamageDone(opponentStats.previousHP, opponentStats.currentHP);
                opponentNumberDead = opponentStats.crowdSize - ((opponentStats.currentHP/opponentStats.maxHP) * opponentStats.crowdSize);
            }
            const myPogChampLocations = this.getPogChampLocations(myStats, false);
            const opponentPogChampLocations = this.getPogChampLocations(opponentStats, false);
            return ( 
                <div>
                    {this.props.eventType === "KO" &&
                        <img className="endGame" src={this.didIWin(myStats) ? "/gifs/tofu.gif" : "/images/losetext.png"}></img>
                    }
                    <div className="battle">
                        {Array.apply(null, {length: myStats.pogChamps }).map((e, i) => (
                            <div className="pogger pog-float mine" style={{ marginLeft: myPogChampLocations[i] }} key={i}></div>
                        ))}
                        {Array.apply(null, {length: opponentStats.pogChamps }).map((e, i) => (
                            <div className="pogger pog-float opponent" style={{ marginLeft: opponentPogChampLocations[i] }} key={i}></div>
                        ))}
                        <Avatar alive={myStats.currentHP !==0 ? true : false} opponent={false} key="me" boss={true} damage={myDamage}/>
                        <Avatar alive={opponentStats.currentHP !==0 ? true : false} opponent={true} key="opponent" boss={true} damage={opponentDamage}/>
                        {Array.apply(null, { length: myStats.crowdSize }).map((e, i) => (
                            <Avatar alive={i < myNumberDead ? false : true} opponent={false} key={i} boss={false} damage={0} throwingRock={i % 5 === 0}/>
                        ))}
                        {Array.apply(null, { length: opponentStats.crowdSize }).map((e, i) => (
                            <Avatar alive={i < opponentNumberDead ? false : true} opponent={true} key={i + myStats.crowdSize} boss={false} damage={0} throwingRock={i % 5 === 0}/>
                        ))}
                    </div>
                </div>
            )
        }
        else {
            return null;
        }
    }

    private didIWin(myStats) {
        if (myStats.currentHP === 0) {
            return false;
        }
        return true;
    }

    private getPogChampLocations(stats, opponent) {
        let positions = [];
        for (let i=0; i < stats.pogChamps; i++) {
            const randomNumber = this.getRandomInt(0, 30);
            let position = "";
            if (opponent) {
                position = 100 - randomNumber - 12 + "%"
            }
            else {
                position = randomNumber + 12 + "%"
            }
            positions.push(position);
        }
        return positions;
    }

    private getDamageDone(currentHealth, newHealth) {
        return currentHealth - newHealth;
    }

    private getMyStats() {
        if (this.props.player1.channelId == this.props.channelId) {
            return this.props.player1;
        }
        return this.props.player2;
    }

    private getOpponentStats() {
        if (this.props.player1.channelId != this.props.channelId) {
            return this.props.player1;
        }
        return this.props.player2;
    }

    private getRandomInt(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
};