import { selectChannelId } from "core/store/modules/TwitchExtension";
import { connect } from "react-redux";
import { BattleComponent } from "./component";
import { getActiveBattle, startBattle, selectPlayer1, selectPlayer2, selectEventType } from "core/store/modules/DreadPirates";

const mapStateToProps = (state) => ({
    channelId: selectChannelId(state),
    player1: selectPlayer1(state),
    player2: selectPlayer2(state),
    eventType: selectEventType(state)
});

const mapDispatchToProps = (dispatch) => ({
  startBattle: (channelID) => {
    dispatch(startBattle({ channelID }));
    let getActiveBattlePoller = setInterval(() => {
        dispatch(getActiveBattle({ channelID }))
    }, 10000);
    dispatch(getActiveBattle({ channelID }))
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  startBattle: () => dispatchProps.startBattle(stateProps.channelId),
});

export const BattleContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(BattleComponent);
