import * as React from "react";
import "./styles.scss";

export interface Props {
    marginLeft: string;
    flip: boolean;
    animationDelayMS: number;
}

export class Rock extends React.Component<Props> {
    public render() {
        const { flip, marginLeft } = this.props;
        const containerStyle = {
            marginLeft,
            transform: flip ? "scaleX(-1)" : "none",
        };
        const imageStyle = {
            animationDelay: this.props.animationDelayMS + "ms",
        };
        return (
            <div className={"thrown-rock"} style={containerStyle}>
                <img className="rock-image" src="/images/thrown_rock.png" style={imageStyle} />
            </div>
        );
    }
}
