import * as React from "react";
import "./styles.scss";

export interface Props {
    startBattle: () => void;
}

export interface State {
  show: boolean;
}

export class StartBattleButtonComponent extends React.Component<Props, State> {
    public state = {show: true}

    public render() {
        const { show } = this.state;

        return (
          <div id="start-battle-button" className="start-battle">
          {show
              ?
                  <div className="start-battle__button" onClick={this.onclickFunction}></div>
              :
                  <div className="start-battle__loading"></div>
          }
          </div>
        )
    }

    private onclickFunction = () => {
        this.setState({show:false});
        this.props.startBattle();
    }
};
