import { selectChannelId } from "core/store/modules/TwitchExtension";
import { connect } from "react-redux";
import { StartBattleButtonComponent } from "./component";
import { getActiveBattle, startBattle } from "core/store/modules/DreadPirates";

const mapStateToProps = (state) => ({
    channelId: selectChannelId(state)
});

const mapDispatchToProps = (dispatch) => ({
  startBattle: (channelId) => {
    dispatch(startBattle({ channelID: channelId }));
    let getActiveBattlePoller = setInterval(() => {
        dispatch(getActiveBattle({ channelID: channelId }))
    }, 10000);
  },
});

const mergeProps = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  startBattle: () => dispatchProps.startBattle(stateProps.channelId),
});

export const StartBattleButtonContainer = connect(mapStateToProps, mapDispatchToProps, mergeProps)(StartBattleButtonComponent);
