# The Sumo Minigame

Isengard account: [samus-aws+sumo@amazon.com](https://isengard.amazon.com/account/270774693661).

See nicokuhn@ for questions.

API
=============
[See Tech design doc for now](https://w.amazon.com/bin/preview/Samus/Tech/DAM/Designs/ExtensionGame/v3/WebHome)

| Environment   | Endpoint                                                          |
| ------------- |-------------------------------------------------------------------|
| Development   | http://localhost:3000                                             |
| Load balancer | http://sumo-game.us-west-2.elasticbeanstalk.com                   |
| Production    | https://aimpet9rkc.execute-api.us-west-2.amazonaws.com/production |

This service is setup in ElasticBeanstalk. Requests to the production endpoint hit API Gateway, which forwards requests to a load balancer hitting one host.

We're using express as our web application framework.

### Deploying to our host
We're not using continuous deployment yet. We rely on `eb deploy` for now:
* Open [Isengard](https://isengard.amazon.com/console-access) and search for the `samus-aws+sumo@amazon.com` account.
* Open the temporary credentials by clicking on the icon next to the "Admin" role. Copy and paste the AWS CLI temporary credentials for your machine into your terminal. You will need to do this again periodically (or you will get a `NotAuthorizedError - Operation Denied` error).
* Navigate to your local version of this repository.
* If you haven't already, install the [eb cli](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/eb-cli3.html) and if necessary run `eb init` in your local repository. If prompted, use the default region 3 (US West - Oregon), use application `sumo`, and use environment name `Sumo-game-env` as the environment. Do not use CodeDeploy.
* Run `npm run deploy` in your terminal.

### Changing environment
1. Manually create a new environment via the ElasticBeanstalk console.
1. Delete the `.elasticbeanstalk/config.yml` file.
1. Run `eb init` and follow the instructions to select your new environment. 